% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getMH}
\alias{getMH}
\title{Get the matrices M and H for the clustered data for the GEE case}
\usage{
getMH(y, X, id, beta, rho, linkv, corstrv)
}
\arguments{
\item{y}{A matrix containing current response variable}

\item{X}{A data frame containing the covariate for the current samples}

\item{id}{The id for each subject in the X}

\item{beta}{The paramters that we estimate when we use the current samples}

\item{rho}{A numeric number indicating the estimate of correlation
coefficient}

\item{linkv}{A specification for the model link function.}

\item{corstrv}{A character string specifying the correlation structure. The
following are permitted: "independence", "exchangeable" and "ar1".}
}
\value{
a list contains several components
\item{sandwich}{the sandwich information matrix for covariance}
\item{M}{the matrix for calculating the sandwich information matrix for covariance}
\item{H}{the matrix for calculating the sandwich information matrix for covariance}
}
\description{
Get the matrices M and H to approximate the true covariance
  matrix of the GEE case
}
\details{
getMH uses the current samples to obtain the covariance matrix.
}
