% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{QIC}
\alias{QIC}
\title{Calculate quasi-likelihood under the independence model criterion
  (QIC) for Generalized Estimating Equations.}
\usage{
QIC(y, X, id, beta, nonZeroSet, rho, linkv, corstrv)
}
\arguments{
\item{y}{A matrix containing current response variable}

\item{X}{A data frame containing the covariate for the current samples}

\item{id}{The id for each subject in the X}

\item{beta}{The paramters that we estimate when we use the current samples}

\item{nonZeroSet}{The set of the index of the non zero coefficient}

\item{rho}{A numeric number indicating the estimate of correlation coefficient}

\item{linkv}{A specification for the model link function.}

\item{corstrv}{A character string specifying the correlation structure. The
following are permitted: "independence", "exchangeable" and "ar1".}
}
\value{
a value indicating how well the model fits
}
\description{
Select the optimal model according to the QIC criterion
}
\details{
QIC calculates the value of the quasi-likelihood under the independence
model criterion for Generalized Estimating Equations. The QIC criterion is
actually a generalization of the AIC criterion in the statistical inference
of parameters in the longitudinal data analysis framework.
}
