% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures_methods.R
\name{as.data.table.sento_measures}
\alias{as.data.table.sento_measures}
\title{Get the sentiment measures}
\usage{
\method{as.data.table}{sento_measures}(x, keep.rownames = FALSE, format = "wide", ...)
}
\arguments{
\item{x}{a \code{sento_measures} object created using \code{\link{sento_measures}}.}

\item{keep.rownames}{see \code{\link{as.data.table}}.}

\item{format}{a single \code{character} vector, one of \code{c("wide", "long")}.}

\item{...}{not used.}
}
\value{
The panel of sentiment measures under \code{sento_measures[["measures"]]},
in wide or long format.
}
\description{
Extracts the sentiment measures \code{data.table} in either wide (by default)
or long format.
}
\examples{
data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

sm <- sento_measures(sento_corpus(corpusdf = usnews[1:200, ]),
                     sento_lexicons(list_lexicons["LM_en"]),
                     ctr_agg(lag = 3))

data.table::as.data.table(sm)
data.table::as.data.table(sm, format = "long")

}
\author{
Samuel Borms
}
