% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures_methods.R
\name{scale.sento_measures}
\alias{scale.sento_measures}
\title{Scaling and centering of sentiment measures}
\usage{
\method{scale}{sento_measures}(x, center = TRUE, scale = TRUE)
}
\arguments{
\item{x}{a \code{sento_measures} object created using \code{\link{sento_measures}}.}

\item{center}{a \code{logical} or a \code{numeric} vector, see documentation for the generic \code{\link{scale}}.
Alternatively, one can provide a \code{matrix} of dimensions \code{nobs(sento_measures)} times \code{1} or
\code{nmeasures(sento_measures)} with values to add to each individual observation.}

\item{scale}{a \code{logical} or a \code{numeric} vector, see documentation for the generic \code{\link{scale}}.
Alternatively, one can provide a \code{matrix} of dimensions \code{nobs(sento_measures)} times \code{1} or
\code{nmeasures(sento_measures)} with values to divide each individual observation by.}
}
\value{
A modified \code{sento_measures} object, with the measures replaced by the scaled measures as well as updated
statistics.
}
\description{
Scales and centers the sentiment measures from a \code{sento_measures} object, column-per-column. By default,
the measures are normalized. \code{NA}s are removed first.
}
\details{
If one of the arguments \code{center} or \code{scale} is a \code{matrix}, this operation will be applied first,
and eventual other centering or scaling is computed on that data.
}
\examples{
data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

set.seed(505)

# construct a sento_measures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")], list_valence_shifters[["en"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sento_measures <- sento_measures(corpusSample, l, ctr)

# scale sentiment measures to zero mean and unit standard deviation
sc1 <- scale(sento_measures)

n <- nobs(sento_measures)
m <- nmeasures(sento_measures)

# add a matrix
sc2 <- scale(sento_measures, center = matrix(runif(n * m), n, m), scale = FALSE)

# divide every row observation based on a one-column matrix, then center
sc3 <- scale(sento_measures, center = TRUE, scale = matrix(runif(n)))

}
\author{
Samuel Borms
}
