% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentometrics.R
\docType{data}
\name{epu}
\alias{epu}
\title{Monthly Economic Policy Uncertainty Index}
\format{A \code{data.frame} with 417 rows and 4 columns.}
\source{
\href{http://www.policyuncertainty.com/research.html}{Research on Economic Policy Uncertainty}
}
\usage{
data("epu")
}
\description{
Monthly values of a news-based index of U.S. Economic Policy Uncertainty (EPU) between January 1980 and September
2014, including a binomial and a multinomial example series. For more information on its calculation, see
\href{http://www.policyuncertainty.com/methodology.html}{this}. Following columns are present:

\itemize{
  \item date. Date as \code{"yyyy-mm-01"}.
  \item index. A \code{numeric} monthly index value.
  \item above. A \code{factor} with value \code{"above"} if the index is greater than the mean of the entire series, else
  \code{"below"}.
  \item aboveMulti. A \code{factor} with values \code{"above+"}, \code{"above"}, \code{"below"} and \code{"below-"} if the
  index is greater than the 75\% quantile and the 50\% quantile, or smaller than the 50\% quantile and the 25\% quantile,
  respectively and in a mutually exclusive sense.
}
}
\examples{
data("epu", package = "sentometrics")
head(epu)

}
\keyword{datasets}
