% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol_indices.R
\name{sobol_dummy}
\alias{sobol_dummy}
\title{Computation of Sobol' indices for a dummy parameter}
\usage{
sobol_dummy(Y, params, R, n, parallel = "no", ncpus = 1)
}
\arguments{
\item{Y}{Numeric vector, model output.}

\item{params}{Vector with the name of the model inputs.}

\item{R}{Integer, number of bootstrap replicas.}

\item{n}{Integer, sample size of the sample matrix.}

\item{parallel}{The type of parallel operation to be used (if any).
If missing, the default is taken from the option "boot.parallel"
(and if that is not set, "no"). For more information, check the
\code{parallel} option in the \code{boot} function of the \code{\link{boot}} package.}

\item{ncpus}{Integer: number of processes to be used in parallel operation:
typically one would chose this to the number of available CPUs.
Check the \code{ncpus} option in the \code{boot} function of the \code{\link{boot}} package.}
}
\value{
A data.table object. It includes a column with the results of the bootstrap.
}
\description{
This function computes first and total-order Sobol' indices for a dummy
parameter following the formulas shown
in \insertCite{KhorashadiZadeh2017;textual}{sensobol}.
}
\examples{
# Define settings:
n <- 100; k <- 8; R <- 10
# Design the sample matrix:
A <- sobol_matrices(n = n, k = k, second = TRUE, third = TRUE)
# Compute the model output:
Y <- sobol_Fun(A)
# Compute the Sobol' indices for the dummy parameter:
sobol_dummy(Y = Y, params = colnames(data.frame(A)), R = R, n = n)
}
\references{
\insertAllCited{}
}
\seealso{
Check the function \code{\link{boot}} for further details on the bootstrapping
and the components available within the class \code{boot}.
}
