% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol_matrices.R
\name{sobol_matrices}
\alias{sobol_matrices}
\title{Creation of the sample matrices}
\usage{
sobol_matrices(n, k, second = FALSE, third = FALSE, cluster = NULL)
}
\arguments{
\item{n}{Integer, sample size of the Sobol' matrix.}

\item{k}{Integer, number of model inputs.}

\item{second}{Logical. If \code{second = TRUE}, it creates the scrambled
matrix required to compute second-order indices. Default is \code{second = FALSE}.}

\item{third}{Logical. If \code{third = TRUE}, it creates the scrambled
matrix required to compute third-order indices. Default is \code{third = FALSE}.}

\item{cluster}{List of vectors, each vector including the column number
of the parameters forming the cluster. The default is \code{cluster = NULL}}
}
\value{
A matrix.
}
\description{
It creates the sample matrices to compute Sobol' first and total-order indices.
If needed, it also creates the sample matrices required to compute second and
third-order indices. It uses Sobol' quasi-random number sequences.
}
\details{
If \code{cluster = NULL}, the function generates an \eqn{(n, 2k)} matrix using Sobol' quasi-random
number sequences. The first \emph{k}-matrix is the \strong{A} matrix and the
remaining \emph{k}-matrix, the \strong{B} matrix. It then generates \emph{k}
additional matrices {(\strong{A}^j_{\strong{B}})}, \eqn{j=1,2,...,k}, where
the \emph{k} matrix is composed of all columns of the \strong{A} matrix
except the \emph{j}-th column, which is the \emph{j} column of the
\strong{B} matrix. This approach leds to a total number of model runs of
\eqn{n(k + 2)} for first and total-order indices \insertCite{Saltelli2010a}{sensobol}.

If a list of vectors is assigned to \code{cluster}, the output is a scrambled matrix
with all columns from matrix \strong{A} except those of the parameters included in the cluster, which
come from matrix \strong{B}.
}
\examples{
sobol_matrices(n = 100, k = 8, second = TRUE, third = TRUE)
}
\references{
\insertAllCited{}
}
\seealso{
Check the function \code{\link{sobol}} in the package \code{randtoolbox}
to see how the Sobol' quasi-random number sequences are constructed.
}
