% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensi_plot.sensiSamp.R
\name{sensi_plot.sensiSamp}
\alias{sensi_plot.sensiSamp}
\title{Graphical diagnostics for class 'sensiSamp'}
\usage{
\method{sensi_plot}{sensiSamp}(x, graphs = "all", param = "slope", ...)
}
\arguments{
\item{x}{output from \code{samp_phylm}}

\item{graphs}{choose which graph should be printed on the output ("all", 1,2,3 or 4)}

\item{param}{choose which model parameter should be ploted  ("intercept" or "slope")}

\item{...}{further arguments to methods}
}
\description{
\code{plot_samp_phylm} Plot results from \code{samp_phylm} and
\code{influ_phyloglm}
}
\details{
For 'x' from samp_phylm or samp_phyglm:

Graph 1: Estimated slopes or intercepts for each simution across  
percentages of species removed. Colours represent percentage 
of change in comparison with the full model (blue = lower than 5, orange = 
between 5 and 10 and red = higher than 10).
The red horizontal line represents the original slope or 
intercept from the full model (with all species). 

Graph 2: The proportion of estimated slopes and intercepts in each category 
across the percentage of species removed.

Graph 3: Estimated phylogenetic model parameter for each simulation across
the percentage of species removed.

Graph 4: The percentage of significant slopes or intercepts across the 
percentage of species removed.
}
\note{
If model = "BM", only plots 1, 2 and 4 are printed. Plot 3, phylogenetic
 model parameter is not available for model = "BM"
}
\author{
Gustavo Paterno
}
\seealso{
\code{\link[ggplot2]{ggplot}}, \code{\link[sensiPhy]{samp_phylm}}
\code{\link[sensiPhy]{samp_phyglm}}
}

