% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gipp.R
\name{gipp_init}
\alias{gipp_init}
\title{Copy L2A_GIPP.xml in sen2r}
\usage{
gipp_init(gipp_sen2r_path = NA, force = FALSE, dem_warning = FALSE)
}
\arguments{
\item{gipp_sen2r_path}{Character path of the output GIPP XML file.
By default it is equal to NA (meaning the default sen2r GIPP path).}

\item{force}{Logical: if TRUE, the file is copied in any case;
if FALSE (default), only if it does not yet exist.}

\item{dem_warning}{TEMPORARY ARGUMENT Logical: if TRUE, a warning about
the fact that DEM_Directory XML parameter was not overwritten is shown
(default is FALSE).
This argument will be removed when use_dem = TRUE will become the default.}
}
\value{
TRUE if the file was copied, FALSE elsewhere (invisible output)
}
\description{
Internal function to copy L2A_GIPP.xml from default Sen2Cor
directory to sen2r. After that, user will allow editing Sen2Cor options
in sen2r without affecting standalone Sen2Cor behaviour.
}
\note{
License: GPL 3.0
}
\examples{
\dontrun{
gipp_init()
}
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2020) \email{luigi@ranghetti.info}
}
\keyword{internal}
