% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_indices_db.R
\name{create_indices_db}
\alias{create_indices_db}
\title{Create the indices database}
\usage{
create_indices_db(xslt_path = NA, json_path = NA, force = FALSE)
}
\arguments{
\item{xslt_path}{(optional) The path where to install \code{xsltml},
an external \code{xsltproc} script used to convert MathML index formulas
to LaTeX (default: a subdirectory of the package).}

\item{json_path}{(optional) The path of the output JSON file.
\emph{Warning}: to create a file which will be usable by the package,
this option must be left to NA (default location is within the
package installation). Edit this only to create the file in another
place for external use.}

\item{force}{(optional) Logical: if FALSE (default), the db is created only
if missing or not updated; if TRUE, it is created in any case.}
}
\value{
NULL (the function is called for its side effects)
}
\description{
The internal function checks if indices.json (the
database of spectral indices) already exists; if not, it
downloads source files and creates it.
Since this function depends on \code{xsltproc} executable (available
only for Linux), this function can be used only from from
Linux. It is not necessary, since a indices.json file is
present in the package.
}
\note{
License: GPL 3.0
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
\keyword{internal}
