% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pars_id.R
\name{pars_id}
\alias{pars_id}
\title{Convert Parameter Syntax to Position
or Row Numbers in the Parameter
Vector or Table}
\usage{
pars_id(pars, fit, where = c("coef", "partable"), free_only = TRUE)
}
\arguments{
\item{pars}{A character vector of parameters specified
in lavaan syntax, e.g., \code{"y ~ x"} and \code{f1 =~ x3}. Can
mix specific parameters with operators. See the Details
section.}

\item{fit}{A \code{lavaan}-class object. This object is used
to determine the number of groups and the parameters
in the model. Only parameters in \code{pars} that appear in
this model will be considered.}

\item{where}{Where the values are to be found. Can be
"partable" (parameter table) or "coef"
(coefficient vector).
Default is "coef".}

\item{free_only}{Wether only free parameters will be
kept. Default is \code{TRUE}.}
}
\value{
A numeric vector of the ids in the column "free" in the
parameter table of the fit object.
}
\description{
Converts a vector of
lavaan syntax to the ids of parameters
in the vector of free parameters or the row numbers
in the parameter table.
}
\details{
It supports the following ways to specify
the parameters to be included.
\itemize{
\item \code{lavaan} syntax
\itemize{
\item For example, \code{"y ~ x"} denotes the regression coefficient
regression \code{y} on \code{x}. It uses \code{\link[lavaan:model.syntax]{lavaan::lavaanify()}} to
parse the syntax strings.
}
\item Operator
\itemize{
\item For example, \code{"~"} denotes all regression coefficients.
}
}

It is used by function such as \code{\link[=est_change]{est_change()}} and
\code{\link[=fit_measures_change]{fit_measures_change()}}.
}
\examples{

dat <- sem_dat

library(lavaan)
sem_model <-
"
f1 =~  x1 + x2 + x3
f2 =~  x4 + x5 + x6
f3 =~  x7 + x8 + x9
f2 ~   f1
f3 ~   f2
"

fit_ng <- sem(sem_model, dat)

pars <- c("f1 =~ x2", "f2 =~ x5", "f2 ~ f1")
tmp <- pars_id(pars, fit = fit_ng)
coef(fit_ng)[tmp]
tmp <- pars_id(pars, fit = fit_ng, where = "partable")
parameterTable(fit_ng)[tmp, ]


}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
