% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropdown_menu_output.R
\name{render_dropdown_menu}
\alias{render_dropdown_menu}
\alias{renderDropdownMenu}
\title{Create a dropdown menu output.}
\usage{
render_dropdown_menu(expr, env = parent.frame(), quoted = FALSE)

renderDropdownMenu(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{expr}{dropdownMenu.}

\item{env}{The environment in which to evaluate expr.}

\item{quoted}{Is expr a quoted expression (with \code{quote()})? This is useful if you want to save an expression in a variable.}
}
\value{
A dynamic dropdown menu that can be assigned to output.
}
\description{
Server-side function for dynamic dropdownMenu.
}
\section{Functions}{
\itemize{
\item \code{renderDropdownMenu}: Create a dropdown menu output (alias for \code{render_dropdown_menu} for compatibility with \code{shinydashboard})
}}

\examples{
\donttest{
dropdownMenuOutput("dropdown")

output$dropdown <- renderDropdownMenu({
  dropdownMenu(messageItem("Michał", "Test message", color = "teal"),
              messageItem("Marek", "Another test!", icon = "warning", color = "red"))
})
}
}
