% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingBootstrap.R
\docType{class}
\name{BootMiss-class}
\alias{BootMiss-class}
\alias{show,BootMiss-method}
\alias{summary,BootMiss-method}
\alias{hist,BootMiss-method}
\alias{show,BootMiss-method}
\alias{summary,BootMiss-method}
\alias{hist,BootMiss-method}
\title{Class For the Results of Bollen-Stine Bootstrap with Incomplete Data}
\usage{
\S4method{show}{BootMiss}(object)

\S4method{summary}{BootMiss}(object)

\S4method{hist}{BootMiss}(x, ..., alpha = 0.05, nd = 2,
  printLegend = TRUE, legendArgs = list(x = "topleft"))
}
\arguments{
\item{object, x}{object of class \code{BootMiss}}

\item{...}{Additional arguments to pass to \code{\link[graphics]{hist}}}

\item{alpha}{alpha level used to draw confidence limits}

\item{nd}{number of digits to display}

\item{printLegend}{\code{logical}. If \code{TRUE} (default), a legend will
be printed with the histogram}

\item{legendArgs}{\code{list} of arguments passed to the
\code{\link[graphics]{legend}} function.  The default argument is a list
placing the legend at the top-left of the figure.}
}
\value{
The \code{hist} method returns a list of \code{length == 2},
 containing the arguments for the call to \code{hist} and the arguments
 to the call for \code{legend}, respectively.
}
\description{
This class contains the results of Bollen-Stine bootstrap with missing data.
}
\section{Slots}{

\describe{
\item{\code{time}}{A list containing 2 \code{difftime} objects (\code{transform}
and \code{fit}), indicating the time elapsed for data transformation and
for fitting the model to bootstrap data sets, respectively.}

\item{\code{transData}}{Transformed data}

\item{\code{bootDist}}{The vector of \eqn{chi^2} values from bootstrap data sets
fitted by the target model}

\item{\code{origChi}}{The \eqn{chi^2} value from the original data set}

\item{\code{df}}{The degree of freedom of the model}

\item{\code{bootP}}{The \emph{p} value comparing the original \eqn{chi^2} with the
bootstrap distribution}
}}

\section{Objects from the Class}{
 Objects can be created via the
\code{\link{bsBootMiss}} function.
}

\examples{

# See the example from the bsBootMiss function

}
\seealso{
\code{\link{bsBootMiss}}
}
\author{
Terrence D. Jorgensen (University of Amsterdam;
\email{TJorgensen314@gmail.com})
}
