\name{read.splsm}
\Rdversion{1.1}
\alias{read.splsm}

\title{
  Import of XML Model Description Specified in SmartPLS
}
\description{
  Imports a .splsm file, an XML model description,
  specified in SmartPLS (see references). Note, that moderator effects
  specified within SmartPLS are not yet supported. Nevertheless
  moderating effects can be specified manually.
}

\usage{
read.splsm(file=character(), order=c("generic", "alphabetical"))
}

\arguments{
  \item{file}{
     A \code{character} naming the path to the \code{.splsm} file
     produced by SmartPLS.
}
  \item{order}{
     A \code{character} describing how to order the latent variables
     (LVs). If
    \itemize{
      \item \code{"generic"} the LVs will be ordered according to their
                            appearance in the causal chain of the
			    structural model (default).
      \item \code{"alphabetical"} the LVs will be ordered
      alphabetically.
    }
  }
}

\value{
The object returned is of class \code{splsm} with the elements:
\item{connectionIDs}{A \code{data.frame} containing a source id
  and target id for all connections of the path model, as specified
  in the \code{.splsm} file produced by SmartPLS. The ids refer to
  the nodes of latent and manifest variable.}
\item{variables}{A \code{data.frame} containing the names of all the
  nodes together with their id and \eqn{x} -, \eqn{y}-position on the
  SmartPLS GUI.}
\item{latent}{A character vector naming the latent variables.}
\item{manifest}{A \code{character} vector naming the manifest variables.}
\item{path}{Is somehow identical with \code{connectionIDs}, only that
  the node ids are replaced by their names.}
\item{strucmod}{Contains only the subset of \code{path} representing the
  structural model.}
\item{measuremod}{Contains only the subset of \code{path} representing
  the measurement model.}
\item{D}{The adjacency matrix \eqn{\bm{D}} for the structural model.}
\item{M}{The adjacency matrix \eqn{\bm{M}} for the measurement model.}
\item{blocks}{
  A \code{list} naming the MVs belonging to each LV's block
  and telling their measurement mode.
}
\item{order}{
    See armguments section.
  }
}

\references{
  Ringle, C.M./Wende, S./Will, S.: SmartPLS 2.0 (M3) Beta, Hamburg 2005,
  \url{http://www.smartpls.de}.
}

\seealso{
  \code{\link{sempls}}, \code{\link{plsm}}
}

\examples{
# getting the path to file: 'ECSI_Tenenhaus.splsm' (generated by SmartPLS)
ptf <- system.file("SmartPLS", "workspace", "ecsi", "ECSI_Tenenhaus.splsm",
                   package="semPLS")

# creating the model specification to use with 'sempls()'.
ECSI <- read.splsm(ptf)
ECSI
}
