% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{elem_attr}
\alias{elem_attr}
\alias{elem_attrs}
\alias{elem_value}
\title{Get attributes of an element}
\usage{
elem_attr(x, name, default = NULL, timeout = NULL)

elem_attrs(x, timeout = NULL)

elem_value(x, ptype = character(), timeout = NULL)
}
\arguments{
\item{x}{A \code{selenider_element} object.}

\item{name}{The name of the attribute to get; a string.}

\item{default}{The default value to use if the attribute does not exist in
the element.}

\item{timeout}{The time to wait for \code{x} to exist.}

\item{ptype}{The type to cast the value to. Useful when the value is an
integer or decimal number. By default, the value is returned as a string.}
}
\value{
\code{elem_attr()} returns a character vector of length 1. \code{elem_attrs()}
returns a named list of strings. The return value of \code{elem_value()} has the
same type as \code{ptype} and length 1.
}
\description{
Get an attribute of a \code{selenider_element} object.

\code{elem_attr()} returns a \emph{single} attribute value as a string.

\code{elem_attrs()} returns a named list containing \emph{every} attribute.

\code{elem_value()} returns the 'value' attribute.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<a class='link' href='https://r-project.org'>R</a>
<input type='number' value='0'>
"

session <- minimal_selenider_session(html)

s("a") |>
  elem_attr("href")

s("a") |>
  elem_attrs()

s("input[type='number']") |>
  elem_value(ptype = integer())
\dontshow{\}) # examplesIf}
}
\seealso{
Other properties: 
\code{\link{elem_css_property}()},
\code{\link{elem_name}()},
\code{\link{elem_size}()},
\code{\link{elem_text}()}
}
\concept{properties}
