% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{elem_select}
\alias{elem_select}
\title{Select an HTML element}
\usage{
elem_select(
  x,
  value = NULL,
  text = NULL,
  index = NULL,
  timeout = NULL,
  reset_other = TRUE
)
}
\arguments{
\item{x}{A \code{selenider_element} object representing a \code{select} or \code{option}
element.}

\item{value}{If \code{x} is a \code{select} element, the value of the option to
select. Can be a character vector, in which case multiple options will be
selected.}

\item{text}{The text content of the option to select. This does not have to
be a complete match, and multiple options can be selected.}

\item{index}{A vector of indexes. The nth option elements will be selected.}

\item{timeout}{How long to wait for the element to exist.}

\item{reset_other}{If \code{TRUE} (the default), the other options will be
deselected.}
}
\value{
\code{x}, invisibly.
}
\description{
Select or deselect \code{select} and \code{option} elements.
}
\details{
If no arguents apart from \code{x} are supplied, and \code{x} is a \code{select} element,
all options will be deselected.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<select multiple>
  <option value='a'>Option A.</option>
  <option value='b'>Option B.</option>
  <option value='c'>Option C.</option>
</select>
"
session <- minimal_selenider_session(html)

s("select") |>
  elem_select("a")

s("select") |>
  elem_select(text = c("Option A.", "Option C."))

s("select") |>
  elem_select(index = 2, reset_other = FALSE)

# Reset selection
s("select") |>
  elem_select()

s("select") |>
  elem_select("b")
\dontshow{\}) # examplesIf}
}
\seealso{
Other actions: 
\code{\link{elem_click}()},
\code{\link{elem_hover}()},
\code{\link{elem_scroll_to}()},
\code{\link{elem_set_value}()},
\code{\link{elem_submit}()}
}
\concept{actions}
