% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/funs.groupfs.R
\name{factorDesign}
\alias{factorDesign}
\title{Expand a data frame with factors to form a design matrix with the full binary encoding of each factor.}
\usage{
factorDesign(df)
}
\arguments{
\item{df}{Data frame containing some columns which are \code{factors}.}
}
\value{
List containing
\describe{
  \item{x}{Design matrix, the first columns contain any numeric variables from the original date frame.}
  \item{index}{Group membership indicator for expanded matrix.}
}
}
\description{
When using \code{\link{groupfs}} with factor variables call this function first to create a design matrix.
}
\examples{
\dontrun{
fd = factorDesign(warpbreaks)
y = rnorm(nrow(fd$x))
fit = groupfs(fd$x, y, fd$index, maxsteps=2, intercept=F)
pvals = groupfsInf(fit)
}
}

