% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/votes_create_table.R
\name{votes_create_table}
\alias{votes_create_table}
\title{Creating table with votes}
\usage{
votes_create_table(dbname, user, password, host,
  nr_term_of_office = 8, windows = .Platform$OS.type == 'windows')
}
\arguments{
\item{dbname}{name of database}

\item{user}{name of user}

\item{password}{password of database}

\item{host}{name of host}

\item{nr_term_of_office}{number of term of office of Polish Diet; default: 8}

\item{windows}{information of used operation system; 
default: .Platform$OS.type == 'windows'}
}
\value{
invisible NULL
}
\description{
Function \code{votes_create_table} creates a table with votes.
}
\note{
Use only this function for first time, when the \emph{votes} table
is empty. Then use \code{votes_update_table}.

There is a possibility that someone's voice reader broke during voting
and this situation is treated like this deputy was absent. Even if deputy
made a decision, he's/she's vote is 'Nieobecny'.

All information is stored in PostgreSQL database.
}
\examples{
\dontrun{
votes_create_table(dbname, user, password, host, 7, TRUE)
votes_create_table(dbname, user, password, host, 7, FALSE)}

}
\author{
Piotr Smuda
}

