% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{seg_sf}
\alias{seg_sf}
\alias{sample_seg_sf}
\title{Segmentation dataset}
\format{
These datasets are objects of class \code{sf} (inherited from \code{tbl_df},
\code{tbl}, \code{data.frame}) with 2 variables:
\itemize{
\item{\code{id}: identification}
\item{\code{geometry}: polygons}
}

\code{seg_sf}: a dataset with 259 features.

\code{sample_seg_sf}: a dataset with 6 features.
}
\usage{
seg_sf

sample_seg_sf
}
\description{
\code{seg_sf}: a dataset containing segments generated from PlanetScope image,
level 3B, acquired on Feb 18, 2020, with 3.7-meter resolution (Planet Team,
2017), using the multiresolution segmentation method (Baatz and Schape,
2000).

The data was post-processed using the spectral difference algorithm on band
3.

The polygons were simplified using the Douglas-Peucker algorithm in QGIS.

Self-intersections were removed using SAGA's Polygon Self-Intersection.

Segmentation parameters:
\itemize{
\item{\verb{scale parameter}: 500}
\item{\code{shape}: 0.9}
\item{\code{compactness}: 0.1}
}

Spectral difference parameters:
\itemize{
\item{\verb{spectral difference}: 20}
}

Simplification parameter:
\itemize{
\item{\code{distance}: 10-meters}
}

Only those polygons intersecting reference data with an area-perimeter ratio
above 25 were selected.

\code{sample_seg_sf}: a subset of \code{seg_sf} dataset.
}
\examples{
data("seg_sf", package = "segmetric")
data("sample_seg_sf", package = "segmetric")
}
\references{
\itemize{
\item Planet Team, 2017. Planet Application Program
Interface: In Space for Life on Earth. San Francisco,
CA. \url{https://api.planet.com}
\item Baatz, M., Schape, A., 2000. Multiresolution
segmentation - an optimization approach for high
quality multi-scale image segmentation. In: Strobl, J.,
Blaschke, T., Griesebner, G. (Eds.), Angewandte
Geographische Informations-Verarbeitung XII.
Wichmann Verlag, Karlsruhe, Germany, pp. 12-23. <>
}
}
\keyword{datasets}
