\name{Read and plot .F .C output}

\alias{read.plot.cerio.out}
\alias{read.plot.river.out}
\alias{read.plot.zelig.out}
\alias{read.plot.semi.out}
\alias{read.plot.forsucc.out}

\title{Read and plot output from Fortran and C simulation programs}

\description{Reads output file generated by the simulation programs and plots graphics}
\usage{
read.plot.cerio.out(file.out.name,sens=F,pdfout=F)
read.plot.river.out(file.out.name,sens=F,pdfout=F)
read.plot.forsucc.out(file.out.name,sens=F,pdfout=F)
read.plot.zelig.out(fileout,spp,grp1,grp2,pdfout=F)
read.plot.semi.out(fileout,spp,label,pdfout=F,plotmarkov=F,ctd=F)
}

\arguments{
  \item{file.out.name}{name of output file to be read}
  \item{sens}{logical variable to decide whether the output includes sensitivity analysis}
  \item{pdfout}{logical variable to decide whether to produce PDF output}
  \item{fileout}{name of output file to be read}
  \item{spp}{array with codes for species}
  \item{grp1}{array with members of group 1 of species}
  \item{grp2}{array with members of group 2 of species}
  \item{label}{character string for label of plot}
  \item{plotmarkov}{optional logical to decide whether to plot the embedded Markov chain}
  \item{ctd}{optional logical variable to decide how to plot}
}

\details{

zelig: produces two figures, one for stand aggregates and one for basal area by species.

forsucc: produces two figures, one for basal area and the other for density.
semi: produces two figures, one for Markov chain dynamics and one for semi-Markov dynamics.

}
\value{
From cerio, river, and forsucc:
\item{t}{time sequence}
\item{x}{state variable}
\item{val.par}{values of parameters}
\item{label.var}{labels for variables}

From semi:
\item{X}{output from embedded Markov chain projection}
\item{out}{output from semi-Markov simulator}
From zelig:
None 
}

\references{
Acevedo M.F. 2012. Simulation of Ecological and Environmental Models. CRC Press.

Acevedo, M.F., S. Pamarti, M. Ablan, D.L. Urban, and A. Mikler. 2001. Modeling forest landscapes: Parameter estimation from gap models over heterogeneous terrain. Simulation 77:53-68.

Acevedo, M.F., D.L. Urban, and M. Ablan, M. 1995. Transition and gap models of forest dynamics. Ecological Applications 5:1040-1055.
}
\author{
Miguel F. Acevedo \email{Acevedo@unt.edu}
}
\note{
Review documentation on how to use cerio.F, semi.F, zelig.F, river.C, and forsucc.C

The zelig model used here is based on the 2.3 version by D.L. Urban.
}

\seealso{
Interface functions \code{\link{.Fortran}}, \code{\link{.C}}, Wrappers F and C functions \code{\link{cerio.F}}, \code{\link{semi.F}},  \code{\link{zelig.F}}, \code{\link{river.C}}, \code{\link{forsucc.C}}
}
\examples{
\dontrun{
is.loaded("cerio", PACKAGE="seem")

fileout <- cerio.F("chp10","cerio")
x <- read.plot.cerio.out(fileout,pdfout=TRUE)

is.loaded("river", PACKAGE="seem")
fileout <- river.C("chp14","river-sens")
x <- read.plot.river.out(fileout,sens=TRUE)

spp <- c("Post oak", "Black jack oak", "Winged elm", "GreenAsh",
         "CedarElm", "Hackberry", "BurOak", "Pecan")
grp1 <- c(1:3); grp2 <- c(4:8) #upland 3 spp and bottomland 5 spp

is.loaded("zelig", PACKAGE="seem")
fileout <- zelig.F("chp16","gbc")
x <- read.plot.zelig.out(fileout,spp, grp1, grp2)

fileout <- forsucc.C("chp16","forsucc") # forsucc is fileprefix
x <- read.plot.forsucc.out(fileout, sens=FALSE)

spp <- c("Role1", "Role2", "Role3", "Role4")
fileprefix <- "rolesm"; label <- "Semi-Markov Order 1" 
fileout <- semi.F("chp16",fileprefix)
x <- read.plot.semi.out(fileout, spp, label)
}
}
\keyword{ math }
\keyword{ IO }
