% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_point2.R
\name{geom_point2}
\alias{geom_point2}
\alias{geom_jitter2}
\title{Better looking points}
\usage{
geom_point2(..., stroke = 0, shape = 16)

geom_jitter2(..., size = 2, stroke = 0, shape = 16)
}
\arguments{
\item{...}{Other arguments to be passed to \code{geom_point}.}

\item{stroke}{Stroke thickness.}

\item{shape}{Shape of points.}

\item{size}{Size of points.}
}
\description{
Somewhat nicer points (especially in case of transparency) without borders and contour.
}
\examples{
library(ggplot2)
library(see)

normal <- ggplot(iris, aes(x = Petal.Width, y = Sepal.Length)) +
  geom_point(size = 8, alpha = 0.3) +
  theme_modern()

new <- ggplot(iris, aes(x = Petal.Width, y = Sepal.Length)) +
  geom_point2(size = 8, alpha = 0.3) +
  theme_modern()

plots(normal, new, n_columns = 2)

}
