% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udg.R
\name{udg}
\alias{AIC.seas}
\alias{BIC.seas}
\alias{logLik.seas}
\alias{nobs.seas}
\alias{qs}
\alias{udg}
\title{Diagnostical Statistics}
\usage{
udg(x, stats = NULL, simplify = TRUE, fail = TRUE, data.frame = FALSE)

qs(x)

\method{AIC}{seas}(object, ...)

\method{BIC}{seas}(object, ...)

\method{nobs}{seas}(object, ...)

\method{logLik}{seas}(object, ...)
}
\arguments{
\item{x, object}{an object of class \code{"seas"}.}

\item{stats}{character vector; if specified, only a subset of the available 
stats are returned. This speeds up the call, as only a subset needs to be 
type converted. Should be used for programming.}

\item{simplify}{logical; should the result be simplified to a vector or 
matrix, if possible?}

\item{fail}{logical; if \code{TRUE}, an error is droped if an element of 
\code{stats} is missing in \code{names(udg(x))}.}

\item{data.frame}{logical; if \code{TRUE}, the output is returned as a 
data.frame. This is useful for further processing (experimental).}

\item{...}{further arguments (not used)}
}
\value{
\code{udg} returns a named vector or list, containing the content of 
   the \code{.udg} file.

\code{qs} returns the QS statistics for seasonality of input and
  output series and the corresponding p-values.

\code{AIC}, \code{BIC}, \code{nobs} and \code{logLik} return the 
  corresponding statistics.
}
\description{
The \code{udg} function provides access to a large number of diagnostical
statistics. The \code{qs} function and the \code{AIC}, \code{BIC} and 
\code{logLik} methods are  wrappers that use \code{udg} to access some 
specific diagnostical statistics.
}
\examples{
\dontrun{
m <- seas(AirPassengers, x11 = "")

qs(m)
AIC(m)
BIC(m)
nobs(m)
logLik(m)

# a list with all entries from udg
udg(m)

# extracting a few selected stats from udg
udg(m, c("f3.m02", "f3.m05", "qsori"))  # returns a list
udg(m, c("f3.m02", "f3.m05"))           # returns a vector

# faster than:
udg(m)[c("f3.m01", "f3.m02", "qsori")]
}
}
\references{
Vignette with a more detailed description: 
  \url{http://www.seasonal.website/seasonal.html}
  
  Comprehensive list of R examples from the X-13ARIMA-SEATS manual: 
  \url{http://www.seasonal.website/examples.html}
  
  Official X-13ARIMA-SEATS manual: 
  \url{https://www.census.gov/ts/x13as/docX13ASHTML.pdf}
}
\seealso{
\code{\link{seas}} for the main function.

\code{\link{series}}, for universal X-13 output extraction.

\code{\link{plot.seas}}, for diagnostical plots.

\code{\link{out}}, for accessing the full output of X-13ARIMA-SEATS.
}

