% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/stri_detect_std.R
\name{stri_detect_std}
\alias{stri_detect_std}
\alias{stri_opts_std}
\title{Use standard matching}
\usage{
stri_detect_std(str, pattern, ..., opts_std = NULL)

stri_opts_std(case_insensitive = FALSE, ...)
}
\arguments{
\item{str}{search target}

\item{pattern}{pattern to attempt}

\item{...}{supplementary arguments passed to the underlying functions,
including additional settings for \code{stri_opts_std}}

\item{opts_std}{list; optional arguments used by stri_*_std functions}

\item{case_insensitive}{logical; enable simple case insensitive matching

\code{stri_detect_std} is equivalent to \code{str \%in\% pattern} and is
created to provide a parallel to other search methods.

\code{stri_opts_std}}
}
\value{
logical indicating the matching elements in \code{str}
}
\description{
Functions for matching using standard, defaut matching
}
\examples{
stri_detect_std( letters[1:5], letters[1:2] )  # TRUE TRUE ...
  stri_detect_std( letters[1:5], LETTERS[1:2] )  # ALL FALSE
  stri_detect_std( letters[1:5], LETTERS[1:2], opts_std = list(case_insensitive = TRUE ) )
}
\seealso{
\code{\link[stringi]{stri_detect}}
}

