% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/extract.R
\docType{methods}
\name{[,Searchable,PatternOrCharacter,missing-method}
\alias{[,Searchable,PatternOrCharacter,missing-method}
\alias{[<-,Searchable,character,missing-method}
\alias{extract}
\title{Extraction operators for Searchable object}
\usage{
\S4method{[}{Searchable,PatternOrCharacter,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{Searchable,character,missing}(x, i) <- value
}
\arguments{
\item{x}{Searchable object}

\item{i}{character; pattern with potential match modifiers applied,}

\item{j}{missing; never specified}

\item{...}{additional arguments. See \code{\link[base]{Extract}}}

\item{drop}{For matrices and arrays. If TRUE the result is coerced to the
lowest possible dimension (see the examples). This only works for
extracting elements, not for the replacement. See \code{\link[base]{drop}}
for further details.}

\item{value}{replacement value for replacement functions

The methods for searching respect the modifiers applied to both \code{x} and
\code{i}.}
}
\value{
The values after the extracting methods have been applied:\cr
  \code{\[} returns a subset of \code{x}, but which is not Searchable.  \cr
  \code{\[\[} and \code{\$} return a sinlge element of \code{x}  \cr
}
\description{
Defines  \code{[}, \code{[[}, and \code{$} for Searchable objects
}
\section{\code{[}, \code{[<-} }{


\code{[} and \code{[<-} are used for subsetting and replacing
\strong{zero or more} elemenxts of \code{x}. Used with searchable objects,
these operators differ from normal R operations in the following respects:

\itemize{

\item The search returns elements of
the target that matches \strong{ANY} of the search patterns.

\item Unlike the
its normal behavior, \code{\[} does not guarantee the output to have as many
elements as elements to \code{pattern}.

\item \code{[} does not return a Searchable object. It is thought that
the return valuable will not be subsequently searched. It is easy to turn
the results into a Searchable object using \code{searchable} however.

\item Unlike for environments and hashes, no constraints exist for ensuring
uniqueness for names in vectors and lists. These structures may contain
multiple elements with the same name. Normal attempts to extract by name
yield only the \strong{first} element that matches the name. Using a
\code{Searchable} patterns match yields all matching elements.

}
}
\examples{
# ATOMIC VECTORS:
    v <- c( a=1, b=2, B=3, c=4, c2=5 )
    sv <- searchable(v)


  # FLEXIBLY FIND ELEMENTS BY NAME
    sv[ regex('c') ]
    sv[ fixed('c') ]

    sv[ ignore.case('b') ]


  # FLEXIBLY REPLACEMENT ELEMENTS BY NAME
    sv[ regex('c.?') ]   <- "3rd"


  # SET DEFAULT SEARCH FOR TARGET/OBJECT
    sv <- searchable(v, case_insensitive = TRUE )
    sv['b']
    sv['B']

    sv <- regex(sv)
    sv['c']

    sv <- ignore.case(sv)
    sv['b']
    sv['c']                  # st


  # USE ON (RECURSIVE) LISTS:
    l <- list( a=1, b=2, c=3 )
    sl <- searchable(l)
    sl["b"]
    sl[ ignore.case("B") ]


  # USE WITH MAGRITTR
   \dontrun{
    sl[ "B"  \%>\% ignore.case ]
    "b" \%>\% sl[.]
    "B" \%>\% ignore.case \%>\% sl[.]
   }
}
\seealso{
\code{\link{Searchable}}           \cr
   \code{\link[base]{Extract}}        \cr
   Match mofiers: \code{\link{fixed}}, \code{\link{regex}},
     \code{\link{coll}} and \code{\link{ignore.case}}
   \code{\link{reverse.lookup}}       \cr
}

