% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct.R
\name{read_ct_spec_example}
\alias{read_ct_spec_example}
\title{Read an example controlled terminology specification}
\usage{
read_ct_spec_example(example)
}
\arguments{
\item{example}{The file name of a controlled terminology data set bundled
with \code{{stdm.oak}}, run \code{read_ct_spec_example()} for available example files.}
}
\value{
A \link[tibble:tibble-package]{tibble} with a controlled terminology
specification data set, or a character vector of example file names.
}
\description{
\code{\link[=read_ct_spec_example]{read_ct_spec_example()}} imports one of the bundled controlled terminology
specification data sets as a \link[tibble:tibble-package]{tibble} into R.
}
\examples{
# Leave the `example` parameter as missing for available example files.
read_ct_spec_example()

# Read an example controlled terminology spec file.
read_ct_spec_example("ct-01-cm.csv")

# You may omit the file extension.
read_ct_spec_example("ct-01-cm")

}
