% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence.R
\name{confidence}
\alias{confidence}
\title{Compute Clustering Confidence}
\usage{
confidence(estimate, expectedPairwiseAllocationMatrix)
}
\arguments{
\item{estimate}{A vector of length \code{n}, where \code{i} and \code{j}
are in the same cluster if and only if \code{clustering[i] == clustering[j]}.}

\item{expectedPairwiseAllocationMatrix}{A \code{n}-by-\code{n} symmetric
matrix whose \code{(i,j)} elements gives the estimated expected probability
that items \code{i} and \code{j} are in the same cluster.}
}
\description{
This function computes the confidence values for \code{n} observations
based on a clustering estimate and the expected pairwise allocation
matrix.
}
\examples{
\donttest{
probabilities <- expectedPairwiseAllocationMatrix(iris.clusterings)
clustering <- salso(probabilities)
conf <- confidence(clustering,probabilities)
conf
}

}
\seealso{
\code{\link{expectedPairwiseAllocationMatrix}}, \code{\link{dlso}}, \code{\link{salso}}
}
\author{
David B. Dahl \email{dahl@stat.byu.edu}
}
