% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{calculate_statistics}
\alias{calculate_statistics}
\title{Calculate statistics for a given raster.}
\usage{
calculate_statistics(layercode, raster)
}
\arguments{
\item{layercode}{character. Name of the layer.}

\item{raster}{RasterLayer. The raster you want to calculate statistics for.}
}
\value{
A dataframe with the layercode and all basic statistics.
}
\description{
Method used to calculate the statistics of all layers. It can be re-used to
calculate statistics for a cropped version of the rasters.
}
\examples{
\dontrun{
# calculate statistics of the SST and salinity in the Baltic Sea

# warning using tempdir() implies that data will be downloaded again in the 
# next R session
x <- load_layers(c("BO_sstmax", "BO_salinity"), datadir = tempdir())
e <- extent(13, 31, 52, 66)
baltics <- crop(x, e)
View(rbind(calculate_statistics("SST Baltic Sea", raster(x, layer = 1)))
           calculate_statistics("Salinity Baltic Sea", raster(x, layer = 2)))
}
}
\seealso{
\code{\link{layer_stats}}
}
