% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{driftWn2D}
\alias{driftWn2D}
\title{Drift of the WN diffusion in 2D}
\usage{
driftWn2D(x, A, mu, sigma, rho = 0, maxK = 2L, expTrc = 30)
}
\arguments{
\item{x}{a matrix of dimension \code{c(n, 2)} containing angles. They all must be in \eqn{[\pi,\pi)} so that the truncated wrapping by \code{maxK} windings is able to capture periodicity.}

\item{A}{drift matrix of size \code{c(2, 2)}.}

\item{mu}{a vector of length \code{2} giving the mean.}

\item{sigma}{vector of length \code{2} containing the \strong{square root} of the diagonal of \eqn{\Sigma}, the diffusion matrix.}

\item{rho}{correlation coefficient of \eqn{\Sigma}.}

\item{maxK}{maximum absolute value of the windings considered in the computation of the WN.}

\item{expTrc}{truncation for exponential: \code{exp(x)} with \code{x <= -expTrc} is set to zero. Defaults to \code{30}.}
}
\value{
A matrix of size \code{c(n, 2)} containing the drift evaluated at \code{x}.
}
\description{
Computes the drift of the WN diffusion in 2D in a vectorized way.
}
\examples{
alpha <- 3:1
mu <- c(0, 0)
sigma <- 1:2
rho <- 0.5
Sigma <- diag(sigma^2)
Sigma[1, 2] <- Sigma[2, 1] <- rho * prod(sigma)
A <- alphaToA(alpha = alpha, sigma = sigma, rho = rho)
x <- rbind(c(0, 1), c(1, 0.1), c(pi, pi), c(-pi, -pi), c(pi / 2, 0))
driftWn2D(x = x, A = A, mu = mu, sigma = sigma, rho = rho)
driftWn(x = x, A = A, mu = c(0, 0), Sigma = Sigma)
}
