\name{protectTable}
\alias{protectTable}
\title{protectTable}
\description{....}
\usage{protectTable(outObj, method, ...)}
\arguments{
\item{ outObj }{ a list-object generated by calcFullTable() and possibly changed by primarySuppression(). }
\item{ method }{ the protection algorithmus. Currently 'OPT', 'HITAS' and 'HYPERCUBE' are possible choices }
\item{ ... }{ additional parameters depending on the choice of the suppression algorithm.\cr \cr
If 'HYPERCUBE' is used, it is possible to use parameter 'suppMethod' with possible choices 'minSupps' (suppress cubes with minimal number of secondary suppressions),'minSum' (minimize the sum of units contributing to secondary cell suppressions) and 'minSumLogs' (minimize the log-sum of units contributing to secondary cell suppressions).\cr
Furthermore, 'protectionLevel' with a default value of 80\% can be set. Information on this parameter can be found in Repsilber, D. (1999). \cr
Finally, 'allowZeros' which can be TRUE or FALSE specifies if empty cells may be part of a suppression scheme and 'randomResult' which also can be TRUE or FALSE specifies if several possible suppression cubes are available, a random cube should be chosen or if always the first in list should be selected.\cr \cr
If 'HITAS' is used, the parameter 'solver' (which can be 'glpk', 'lpsolve', 'symphony' or 'cplex' depending on your installed lp-solver and its appropriate R-package) can be used to specify your peferred solver for the occuring (mi)lp programs.\cr
'OPT' is the choice if you want to protect sensitive cells in an optimal way. The entire table is anonmyized in one step (unlike in 'HITAS' where the problem is split into subtables).}
}
\references{
	Repsilber, D. (1999). Das Quaderverfahren. In: Forum der Bundesstatistik, Band 31/1999. \cr
	de Wolf, P.P (2002). HiTaS: A Heuristic Approach to Cell Suppression in Hierarchical Tables. In: Domingo-Ferrer, J. (Hrsg.): Inference Control in Statistical Databases. Vol. 2316.\cr
	Fischetti, M., Salazar, J.J. (2000). Models and Algorithms for Optimizing Cell Suppression in Tabular Data with Linear Constraints. In: Journal of the American Statistical Association 95, 916-928.
}
\value{ an object of class 'safeTable' }
\author{Bernhard Meindl}
\examples{
# generate micro-data
N <- 2500
set.seed(123)
V1 <- sample(c("011","012","013","021","022"), N, replace=TRUE)
V2 <- sample(c("m","w"), N, replace=TRUE)
V3 <- sample(c("01","02"), N, replace=TRUE)
V4 <- sample(c("Aa","Ab", "Ac","Ba","Ca","Da","Db", "Ea","Fa","Fb",
"Ga","Gb","Ha","Ia","Ja","Jb","Ka","Kb"), N, replace=TRUE)
	
microDat <- data.frame(V1=V1,V2=V2,V3=V3,V4=V4)
microDat$numVal <- abs(round(rnorm(N, 500, 200),2))
sInd <- sample(floor(N/20))
microDat$numVal[sInd] <- abs(round(rnorm(sInd, 100000, 200),2))
	
# dimension 1
h1 <- c("@@", "@@@","@@@","@@@","@@", "@@@","@@@")
l1 <- c("010", "011", "012","013","020", "021","022")
df1 <- data.frame(h=h1, l=l1)
hier1 <- calcDimInfos(microDat, file=NULL, dataframe=df1, vName="V1") 

# Level 2
h2 <- c("@@", "@@")
l2 <- c("m", "w")
df2 <- data.frame(h=h2, l=l2)
hier2 <- calcDimInfos(microDat, file=NULL, dataframe=df2, vName="V2") 

# Level 3
h3 <- c("@@", "@@")
l3 <- c("A", "B")
df3 <- data.frame(h=h3, l=l3)
hier3 <- calcDimInfos(microDat, file=NULL, dataframe=df3, vName="V3") 

# Level 4
h4 <- c("@@","@@@","@@@","@@@","@@","@@@","@@","@@@","@@","@@@","@@@",
		"@@","@@@","@@","@@@","@@@","@@","@@@","@@@","@@","@@@",
		"@@","@@@","@@","@@@","@@@","@@","@@@","@@@") 
l4 <- c("A","Aa","Ab","Ac","B","Ba","C","Ca","D","Da","Db",
		"E","Ea","F","Fa","Fb","G","Ga","Gb","H","Ha",
		"I","Ia","J","Ja","Jb","K","Ka","Kb")
df4 <- data.frame(h=h4, l=l4)
hier4 <- calcDimInfos(microDat, file=NULL, dataframe=df4, vName="V4") 

# the complete levelObject
levelObj <- list(hier1, hier2, hier3, hier4)	

outObj <- calcFullTable(microDat, levelObj, numVar="numVal")
outObj <- primarySuppression(outObj, suppRule_Freq=c(3,0))

LPL <- rep(1, length(outObj$fullTabObj$strID)) # non negative
UPL <- rep(1, length(outObj$fullTabObj$strID)) # non negative
SPL <- rep(0, length(outObj$fullTabObj$strID)) # non negative

outObj <- setBounds(outObj, type="UPL", UPL)
outObj <- setBounds(outObj, type="LPL", LPL)
outObj <- setBounds(outObj, type="SPL", SPL)				
outHITAS <- protectTable(outObj, solver="glpk", method="HITAS")
print(str(outHITAS))
}
\keyword{methods}