% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grim-stats.R
\name{grim-stats}
\alias{grim-stats}
\alias{grim_total}
\alias{grim_ratio}
\alias{grim_ratio_upper}
\title{Possible GRIM inconsistencies}
\usage{
grim_total(x, n, items = 1, percent = FALSE)

grim_ratio(x, n, items = 1, percent = FALSE)

grim_ratio_upper(x, percent = FALSE)
}
\arguments{
\item{x}{String or numeric (length 1). Mean or percentage value computed from
data with integer units (e.g., mean scores on a Likert scale or percentage
of study participants in some condition). \emph{Note}: Numeric inputs don't
include trailing zeros, but these are important for GRIM functions. See
documentation for \code{grim()}.}

\item{n}{Integer. Sample size corresponding to \code{x}.}

\item{items}{Integer. Number of items composing the mean or percentage value
in question. Default is \code{1}.}

\item{percent}{Logical. Set \code{percent} to \code{TRUE} if \code{x} is expressed as a
proportion of 100 rather than 1. The functions will then account for this
fact through increasing the decimal count by 2. Default is \code{FALSE}.}
}
\value{
Integer or double. The number or proportion of possible GRIM
inconsistencies.
}
\description{
Even without GRIM-testing, means / proportions and sample sizes
of granular distributions entail some key data:
\itemize{
\item \code{grim_total()} returns the absolute number of GRIM-inconsistencies that
are possible given the mean or percentage's number of decimal places (\code{D})
and the corresponding sample size.
\item \code{grim_ratio()} returns a proportion that is normalized by \code{10^D}, and
therefore comparable across mean or percentage values reported to varying
\code{D}.
\item \code{grim_ratio_upper()} returns the upper bound of \code{grim_ratio()} for a
given \code{D}.
}

For discussion, see \code{vignette("grim")}, section \emph{GRIM statistics}.
}
\examples{
# Many value sets are inconsistent here:
grim_total(x = "83.29", n = 21)
grim_ratio(x = "83.29", n = 21)

# No sets are inconsistent in this case...
grim_total(x = "5.14", n = 83)
grim_ratio(x = "5.14", n = 83)

# ... but most would be if `x` was a percentage:
grim_total(x = "5.14", n = 83, percent = TRUE)
grim_ratio(x = "5.14", n = 83, percent = TRUE)
}
\references{
Brown, N. J. L., & Heathers, J. A. J. (2017). The GRIM Test: A
Simple Technique Detects Numerous Anomalies in the Reporting of Results in
Psychology. \emph{Social Psychological and Personality Science}, 8(4), 363–369.
https://journals.sagepub.com/doi/10.1177/1948550616673876
}
\seealso{
\code{grim()} for the GRIM test itself; as well as \code{grim_map()} for
applying it to many cases at once.
}
