% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debit.R
\name{debit}
\alias{debit}
\title{The DEBIT (descriptive binary) test}
\usage{
debit(
  x,
  sd,
  n,
  formula = "mean_n",
  rounding = "up_or_down",
  threshold = 5,
  symmetric = FALSE
)
}
\arguments{
\item{x}{String. Mean of a binary distribution.}

\item{sd}{String. Sample standard deviation of a binary distribution.}

\item{n}{Integer. Total sample size.}

\item{formula}{String. Formula used to compute the SD of the binary
distribution. Currently, only the default, \code{"mean_n"}, is supported.}

\item{rounding}{String. Rounding method or methods to be used for
reconstructing the SD values to which \code{sd} will be compared. Default is
\code{"up_or_down"} (from 5). See \code{vignette("rounding-options")}.}

\item{threshold}{Integer. If \code{rounding} is set to \code{"up_from"}, \code{"down_from"},
or \code{"up_from_or_down_from"}, set \code{threshold} to the number from which the
reconstructed values should then be rounded up or down. Otherwise
irrelevant. Default is \code{5}.}

\item{symmetric}{Logical. Set \code{symmetric} to \code{TRUE} if the rounding of
negative numbers with \code{"up"}, \code{"down"}, \code{"up_from"}, or \code{"down_from"}
should mirror that of positive numbers so that their absolute values are
always equal. Default is \code{FALSE}.}
}
\value{
Logical. \code{TRUE} if \code{x}, \code{sd}, and \code{n} are mutually consistent,
\code{FALSE} if not.
}
\description{
\code{debit()} tests summaries of binary data for consistency: If the
mean and the standard deviation of binary data are given, are they
consistent with the reported sample size?

The function is vectorized, but it is recommended to use \code{\link[=debit_map]{debit_map()}}
for testing multiple cases.
}
\examples{
# Check single cases of binary
# summary data:
debit(x = "0.36", sd = "0.11", n = 20)
}
\references{
Heathers, James A. J., and Brown, Nicholas J. L. 2019. DEBIT: A
Simple Consistency Test For Binary Data. https://osf.io/5vb3u/.
}
\seealso{
\code{\link[=debit_map]{debit_map()}} applies \code{debit()} to any number of cases at once.
}
