% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-doc-audit.R
\name{write_doc_audit}
\alias{write_doc_audit}
\title{Documentation template for \code{audit()}}
\usage{
write_doc_audit(sample_output, name_test)
}
\arguments{
\item{sample_output}{Data frame. Result of a call to \code{audit()} on a data
frame that resulted from a call to the mapper function for which you wrote
the \code{audit()} method, such as \code{audit(grim_map(pigs1))} or
\code{audit(debit_map(pigs3))}.}

\item{name_test}{String (length 1). Name of the consistency test which the
mapper function applies, such as \code{"GRIM"} or \code{"DEBIT"}.}
}
\value{
A string vector formatted by \code{glue::glue()}.
}
\description{
\code{write_doc_audit()} creates a roxygen2 block section to be
inserted into the documentation of a mapper function such as \code{grim_map()}
or \code{debit_map()}: functions for which there are, or should be, \code{audit()}
methods. The section informs users about the ways in which \code{audit()}
summarizes the results of the respective mapper function.

Copy the output from your console and paste it into the roxygen2 block of
your \verb{*_map()} function. To preserve the numbered list structure when
indenting roxygen2 comments with \code{Ctrl}+\code{Shift}+\code{/}, leave empty lines
between the pasted output and the rest of the block.
}
\examples{
# Start by running `audit()`:
out_grim  <- audit(grim_map(pigs1))
out_debit <- audit(debit_map(pigs3))

out_grim
out_debit

# Documenting the `audit()` method for `grim_map()`:
write_doc_audit(sample_output = out_grim, name_test = "GRIM")

# Documenting the `audit()` method for `debit_map()`:
write_doc_audit(sample_output = out_debit, name_test = "DEBIT")
}
