% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{coef_nnls}
\alias{coef_nnls}
\title{Compute NNLS coefficients}
\usage{
coef_nnls(x, y, eps = 1e-12, max_iter = 1000L)
}
\arguments{
\item{x}{Coefficient matrix (p x n matrix)}

\item{y}{Right hand side (p x m matrix)}

\item{eps}{Convergence tolerance}

\item{max_iter}{Maximum number of iterations}
}
\value{
A list containing
\item{beta}{The estimated coefficient matrix}
\item{iterations}{A vector containing the number of iterations needed
for the \code{i}-th column in \code{y} in the \code{i}-th entry.}
}
\description{
Computes non-negative least squares coefficients with a matrix
right hand side.
}
\references{
Duy Khuong Nguyen and Tu Bao Ho. Accelerated anti-lopsided algorithm
for nonnegative least squares. International Journal of Data Science
and Analytics, 3(1):23–34, 2017.

Adapted from \url{https://github.com/khuongnd/nnls_antilopsided}
}
\keyword{internal}
