% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Create a Heatmap of a Scoring Metric}
\usage{
plot_heatmap(scores, y = "model", x, metric)
}
\arguments{
\item{scores}{A data.frame of scores based on quantile forecasts as
produced by \code{\link[=score]{score()}}.}

\item{y}{The variable from the scores you want to show on the y-Axis. The
default for this is "model"}

\item{x}{The variable from the scores you want to show on the x-Axis. This
could be something like "horizon", or "location"}

\item{metric}{the metric that determines the value and colour shown in the
tiles of the heatmap}
}
\value{
A ggplot2 object showing a heatmap of the desired metric
}
\description{
This function can be used to create a heatmap of one metric across different
groups, e.g. the interval score obtained by several forecasting models in
different locations.
}
\examples{
scores <- score(example_quantile)
scores <- summarise_scores(scores, by = c("model", "target_type", "range"))

plot_heatmap(scores, x = "target_type", metric = "bias")
}
