% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{wis_components}
\alias{wis_components}
\title{Plot Contributions to the Weighted Interval Score}
\usage{
wis_components(
  scores,
  x = "model",
  group = NULL,
  relative_contributions = FALSE,
  facet_formula = NULL,
  scales = "free_y",
  ncol = NULL,
  facet_wrap_or_grid = "facet_wrap",
  x_text_angle = 90,
  xlab = x,
  ylab = "WIS contributions"
)
}
\arguments{
\item{scores}{A data.frame of scores based on quantile forecasts as
produced by \code{\link{eval_forecasts}}}

\item{x}{The variable from the scores you want to show on the x-Axis.
Usually this will be "model"}

\item{group}{Choose a grouping variable for the plot that gets directly
passed down to ggplot. Default is \code{NULL}}

\item{relative_contributions}{show relative contributions instead of absolute
contributions. Default is FALSE and this functionality is not available yet.}

\item{facet_formula}{facetting formula passed down to ggplot. Default is
\code{NULL}}

\item{scales}{scales argument that gets passed down to ggplot. Only necessary
if you make use of facetting. Default is "free_y"}

\item{ncol}{Number of columns for facet wrap. Only relevant if
\code{facet_formula} is given and \code{facet_wrap_or_grid == "facet_wrap"}}

\item{facet_wrap_or_grid}{Use ggplot2's \code{facet_wrap} or
\code{facet_grid}? Anything other than "facet_wrap" will be interpreted as
\code{facet_grid}. This only takes effect if \code{facet_formula} is not
\code{NULL}}

\item{x_text_angle}{Angle for the text on the x-axis. Default is 90}

\item{xlab}{Label for the x-axis. Default is the variable name on the x-axis}

\item{ylab}{Label for the y-axis. Default is "WIS contributions"}
}
\value{
A ggplot2 object showing a contributions from the three components of
the weighted interval score
}
\description{
Visualise the components of the weighted interval score: penalties for
over-prediction, under-prediction and for a lack of sharpness
}
\examples{
scores <- scoringutils::eval_forecasts(scoringutils::quantile_example_data,
                                       summarise_by = c("model", "value_desc"))
scoringutils::wis_components(scores, x = "model", facet_formula = ~ value_desc,
                             relative_contributions = TRUE)
scoringutils::wis_components(scores, x = "model", facet_formula = ~ value_desc,
                             relative_contributions = FALSE)
}
\references{
Bracher J, Ray E, Gneiting T, Reich, N (2020) Evaluating epidemic forecasts
in an interval format. \url{https://arxiv.org/abs/2005.12881}
}
