% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_data_handling.R
\name{range_long_to_wide}
\alias{range_long_to_wide}
\title{Pivot Range Format Forecasts From Long to Wide Format}
\usage{
range_long_to_wide(data)
}
\arguments{
\item{data}{a data.frame following the specifications from
\code{\link{eval_forecasts}}) for quantile forecasts. For an example, see
\code{\link{range_example_data_long}})}
}
\value{
a data.frame in wide format
}
\description{
Given a data.frame that follows the structure shown in
\code{\link{range_example_data_long}}, the function outputs the same
data in a long format as (as shown in
\code{\link{range_example_data_wide}}). This can be useful e.g. for
plotting.
}
\examples{
long <- scoringutils::range_example_data_long
wide <- scoringutils::range_long_to_wide(long)

}
