% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivoting_functions.R
\name{sample_to_quantile}
\alias{sample_to_quantile}
\title{Change Data from a Sample Based Format to a Quantile Format}
\usage{
sample_to_quantile(data, quantiles = c(0.05, 0.25, 0.5, 0.75, 0.95), type = 7)
}
\arguments{
\item{data}{a data.frame with samples}

\item{quantiles}{a numeric vector of quantiles to extract}

\item{type}{type argument passed down to the quantile function. For more
information, see \code{\link{quantile}}}
}
\value{
a data.frame in a long interval range format
}
\description{
Transform data from a format that is based on predictive samples to a format
based on plain quantiles.
}
\examples{
example_data <- scoringutils::integer_example_data

quantile_data <- sample_to_quantile(example_data)

}
