% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{defineClonesScoper}
\alias{defineClonesScoper}
\title{Assigning Ig sequences into clonal groups}
\usage{
defineClonesScoper(db, junction = "JUNCTION", v_call = "V_CALL",
  j_call = "J_CALL", first = FALSE, cdr3 = FALSE, mod3 = FALSE,
  iter_max = 1000, nstart = 25, nproc = 1, progress = FALSE,
  out_name = NULL, out_dir = ".")
}
\arguments{
\item{db}{data.frame with Change-O style columns containing sequence data.}

\item{junction}{name of the column containing nucleotide sequences to compare.
Also used to determine sequence length for grouping.}

\item{v_call}{name of the column containing the V-segment allele calls.}

\item{j_call}{name of the column containing the J-segment allele calls.}

\item{first}{if \code{TRUE} only the first call of the gene assignments
is used. if \code{FALSE} the union of ambiguous gene
assignments is used to group all sequences with any
overlapping gene calls.}

\item{cdr3}{if \code{TRUE} remove 3 nts from both ends of \code{junction}
(converts IMGT junction to CDR3 region). if \code{TRUE} remove \code{junction}(s)
with length less than 7 nts.}

\item{mod3}{if \code{TRUE} remove \code{junction}(s) with number of nucleotides not modulus of 3.}

\item{iter_max}{the maximum number of iterations allowed for kmean clustering step.}

\item{nstart}{the number of random sets chosen for kmean clustering initialization.}

\item{nproc}{number of cores to distribute the function over.}

\item{progress}{if \code{TRUE} print a progress bar.}

\item{out_name}{if not \code{NULL} save cloned data.frame and a summary of cloning
performance. \code{out_name} string is used as the prefix of the successfully
processed output files.}

\item{out_dir}{specify to change the output directory. The input file
directory is used if this is not specified while \code{out_name} is specified.}
}
\value{
Returns a modified \code{db} data.frame with clone identifiers in the \code{CLONE} column.
if \code{out_name} is not \code{NULL}, it will save the modified \code{db} and a summary
of cloning performance in the current directory or the specified \code{out_dir}.
}
\description{
The \code{defineClonesScoper} function provides an unsupervised pipline for assigning Ig sequences into
clonal groups sharing same V gene, J gene, and junction length.
}
\details{
An unsupervised pipeline to identify B cell clones from adaptive immune receptor
repertoire sequencing (AIRR-Seq) datasets. This method is based on spectral clustering
of the junction sequences of B cell receptors (BCRs, also referred to as Immunoglobulins,
(Igs)) that share the same V gene, J gene and junction length. It uses an adaptive
threshold that analyzes sequences in a local neighborhood.
}
\examples{
# clone data using defineClonesScoper function
db <- defineClonesScoper(ExampleDb, junction = "JUNCTION", v_call = "V_CALL",
                         j_call = "J_CALL", first = TRUE)
}
\seealso{
To assess the performance of clonal assignment process check \code{analyzeClones}.
}
