\name{sciopath}
\alias{sciopath}
\title{Compute the SCIO estimates for a grid of penalty values}
\description{
Estimates a sparse inverse covariance matrix using a Sparse Column-wise
Inverse Operator, path-following a  grid  of values for the regularization parameter
}
\usage{
sciopath(S, lambdalist=NULL, thr = 1e-4, maxit = 1e4, pen.diag=F, sym=T)
}
\arguments{
\item{S}{Input covariance matrix of size p by p (symmetric).}
\item{lambdalist}{Vector of non-negative regularization parameters for
  the lasso penalty.  The path  is computed from  the largest
 to the smallest value of this vector. If not given, 10 values are generated.}
\item{thr}{Threshold for convergence.  Iterations stop when the maximum
  change in two successive updates is less than \code{thr}.  Default  1e-4.}
\item{maxit}{Maximum number of iterations for each column computation. Default 10,000.}
\item{pen.diag}{Whether the diagonal should be penalized.  Default False.}
\item{sym}{Whether the return values should be symmetrized.  Default True.}
}

\details{
  This is a fast, nonparametric approach to estimate sparse inverse covariance
  matrices, with possibly really large dimensions.  Details of this procedure are
  described in the reference.
}
\value{
A list with components:
\item{wlist}{Estimated covariance matrices, an array  of dimension (nrow(s),ncol(n), length(lambdalist))}
\item{lambdalist}{Regularization parameters used}
}

\references{
  Weidong Liu and Xi Luo (2012). Fast and Adaptive Sparse Precision
  Matrix Estimation in High Dimensions. arXiv:1203.3896.
}

\examples{
set.seed(100)
x <- matrix(rnorm(50*20),ncol=4)
s <- var(x)
a <- sciopath(s)
}
\keyword{multivariate}
\keyword{models}
\keyword{graphs}

