% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_helpers.R
\name{format_number}
\alias{format_number}
\title{Format human-readable numbers.}
\usage{
format_number(x, nsmall = 1, signif_precise = 2)
}
\arguments{
\item{x}{inline code}

\item{nsmall}{number of digits after the decimal point to round to when \code{x}
is not nearly whole but \code{x >= 1}.}

\item{signif_precise}{number of significant digits to use when \code{x} is not
nearly whole}
}
\value{
formatted \code{x} if numeric, otherwise \code{x} unmodified.
}
\description{
Pastes formatted \code{x} if numeric, otherwise \code{x} unmodified.
Circumvents R's automatic scientific notation.
If a number is nearly whole (see \code{is_nearly_whole()}), it is rounded to have
zero decimal places. Otherwise, numbers >= 1 are rounded to 1 decimal place;
numbers < 1 are rounded to have 2 significant digits.
}
\examples{
format_number(0.0256)
format_number(.Machine$double.eps^0.5)
format_number(100000.08)
format_number(1.00000000000000000001)
format_number("this is a string")
}
\author{
Pat Schloss \email{pschloss@umich.edu}

Kelly Sovacool \email{sovacool@umich.edu}
}
