% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fillmissingSC.R
\name{fillmissingSC}
\alias{fillmissingSC}
\title{Replacing missing measurement times in single-case data}
\usage{
fillmissingSC(data, dvar, mvar, interpolation = "linear", na.rm = TRUE)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about this format.}

\item{dvar}{Character string with the name of the dependent variable. Defaults to the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable. Defaults to the attributes in the scdf file.}

\item{interpolation}{Alternative options not yet included. Default is
\code{interpolation = "linear"}.}

\item{na.rm}{If set \code{TRUE}, \code{NA} values are also interpolated.
Default is \code{na.rm = TRUE}.}
}
\value{
A single-case data frame (SCDF) with missing data points
interpolated.  See \code{\link{scdf}} to learn about the SCDF Format.
}
\description{
The \code{fillmissingSC} function replaces missing measurements in
single-case data.
}
\details{
This procedure is recommended if there are gaps between measurement times
(e.g. MT: 1, 2, 3, 4, 5, ... 8, 9) or explicitly missing values in your
single-case data and you want to calculate overlap indices
(\code{\link{overlapSC}}) or a randomization test (\code{\link{randSC}}).
}
\examples{

## In his study, Grosche (2011) could not realize measurements each single week for 
## all participants. During the course of 100 weeks, about 20 measurements per person 
## at different times were administered.

## Fill missing values in a single-case dataset with discontinuous measurement times
Grosche2011filled <- fillmissingSC(Grosche2011)
study <- c(Grosche2011[2], Grosche2011filled[2])
names(study) <- c("Original", "Filled")
plot(study, style = "grid")

## Fill missing values in a single-case dataset that are NA
Maggie <- rSC(design_rSC(level = list(0,1)), seed = 123)
Maggie_n <- Maggie
replace.positions <- c(10,16,18)
Maggie_n[[1]][replace.positions,"values"] <- NA
Maggie_f <- fillmissingSC(Maggie_n)
study <- c(Maggie, Maggie_n, Maggie_f)
names(study) <- c("original", "missing", "interpolated")
plot(study, marks = list(positions = replace.positions), style = "grid2")

}
\seealso{
Other data manipulation functions: \code{\link{longSCDF}},
  \code{\link{outlierSC}}, \code{\link{rankSC}},
  \code{\link{scaleSC}}, \code{\link{shiftSC}},
  \code{\link{smoothSC}}, \code{\link{truncateSC}}
}
\author{
Juergen Wilbert
}
\concept{data manipulation functions}
\keyword{manip}
