% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeSC.R
\name{describeSC}
\alias{describeSC}
\title{Descriptive statistics for single-case data}
\usage{
describeSC(data, dvar, pvar, mvar)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about this format.}

\item{dvar}{Character string with the name of the dependent variable. Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable. Defaults to the attributes in the scdf file.}
}
\value{
A data frame of descriptive statistics (for each single-case), i.e.:
number of observations, number of missing values, measures of central
tendency, variation, and trend.
}
\description{
The \code{describeSC} function provides common descriptive statistics for
single-case data.
}
\examples{


## Descriptive statistics for a study of three single-cases
describeSC(Grosche2011)

## Descriptives of a three phase design
describeSC(exampleABC)

\dontrun{
## Write descriptive statistics to .csv-file
study <- describeSC(Waddell2011)
write.csv(study$descriptives, file = "descriptives.csv")
}
}
\seealso{
\code{\link{overlapSC}}, \code{\link{plotSC}}
}
\author{
Juergen Wilbert
}
