% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory_inference.R
\name{trajectoryinference}
\alias{trajectoryinference}
\title{trajectoryinference}
\usage{
trajectoryinference(
  data,
  start.idx,
  scDHA_res,
  allCluster,
  ncores = 10L,
  seed = NULL
)
}
\arguments{
\item{data}{A list consists of gene expression matrix.}

\item{start.idx}{The indexes of the start cells, given by user.}

\item{scDHA_res}{The 'scDHA' results, consists of latent and clustering result.}

\item{allCluster}{A list consists of clustering results using 'scDHA' with \code{k = 5:10}.}

\item{ncores}{Number of processor cores to use. This values is set to \code{seed = 10L} by default.}

\item{seed}{A parameter to set a seed for reproducibility.}
}
\value{
List with the following keys:
\itemize{
\item pseudotime - The pseudotime of cells in the data set.
\item cluster  - The clustering results of data set.
\item data_clus_cent - The center of all the clusters.
\item milestone_network - The milestone network of the inferred trajectory.
\item g - An 'igraph' object of the inferred trajectory
}
}
\description{
This is the main function that performs sc-RNA seq data trajectory inference.
The 'scTEP' first load the latent representation and clustering result of scDHA.
Second, the 'trajectoryinference' function iterates through all the clustering results and calculates the distance between clusters as pseudotimes.
Third, it calculates the average pseudotime for every cluster in the clustering result obtained from the first step.
Fourth, it generates an MST and fine-tunes it by the pseudotime. Therefore, we have the trajectory for the data set.
}
\examples{
\donttest{
# Load the package and the example data (goolam data set)
library(scTEP)
#Load pathway genesets
data('genesets')
#Load example data (SCE dataset)
data("goolam")
#Get data matrix and label
expr <- as.matrix(t(SummarizedExperiment::assay(goolam)))
label <- as.character(goolam$label)
stages = goolam@metadata$cell.stages

#Get data matrix and label
data = preprocessing(expr)

#Generate factor analysis results for all the intersections between data matrix and genesets
data_fa = scTEP.fa(data, genesets, ncores = 2, data_org = 'mmu', seed = 1)

#Get clustering results using 'scDHA' with k from 6 to 10.
allCluster = scTEP::clustering(data, ncores = 2)

scDHA_res <- scDHA(data_fa, do.clus = T, gen_fil = T, ncores = 2, seed = 1)
#Conduct trajectory inference to the data matrix
idx = which(label == stages[1])
out = trajectoryinference(data, idx, scDHA_res, allCluster, ncores = 2, seed = 1)

}
}
\references{
1. Duc Tran, Hung Nguyen, Bang Tran, Carlo La Vecchia, Hung N. Luu, Tin Nguyen (2021). Fast and precise single-cell data analysis using a hierarchical autoencoder. Nature Communications, 12, 1029. doi: 10.1038/s41467-021-21312-2
}
