% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCR.CDR3ntLengthDistribution.R
\name{BCR.CDR3ntLengthDistribution}
\alias{BCR.CDR3ntLengthDistribution}
\title{CDR3 nucleic acid length distribution in the sample}
\usage{
BCR.CDR3ntLengthDistribution(contigList, sampleName)
}
\arguments{
\item{contigList}{The product of BCR.ContigList().}

\item{sampleName}{The sample name of single cell sample.}
}
\value{
Multiple pictures in the form of a list.
}
\description{
CDR3 nucleic acid length distribution in the sample
}
\examples{

project_data_dir <- "F:/R_Language/data/bcr"
sample_name <- list.dirs(project_data_dir, full.names = FALSE, recursive = FALSE)
group_name <- c("A", "A", "B", "B")
contig_list <- BCR.ContigList(project_data_dir, sample_name, group_name)

BasicPlot(BCR.CDR3ntLengthDistribution, contig_list, sample_name)
}
