% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tucker.R
\name{get_callouts_annot}
\alias{get_callouts_annot}
\title{Get gene callout annotations for a loadings heatmap}
\usage{
get_callouts_annot(
  container,
  tmp_casted_num,
  factor_select,
  sig_thresh,
  top_n_per_ctype = 5,
  ctypes = NULL
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{tmp_casted_num}{matrix The gene by cell type loadings matrix}

\item{factor_select}{numeric The factor to investigate}

\item{sig_thresh}{numeric Pvalue cutoff for significant genes}

\item{top_n_per_ctype}{numeric The number of significant, largest magnitude
genes from each cell type to generate callouts for (default=5)}

\item{ctypes}{character The cell types for which to get the top genes to make
callouts for. If NULL then uses all cell types. (default=NULL)}
}
\value{
A HeatmapAnnotation object for the gene callouts.
}
\description{
Get gene callout annotations for a loadings heatmap
}
