% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{ensemblToGo}
\alias{ensemblToGo}
\title{get requested ensembl ID to GO mapping table}
\usage{
ensemblToGo(
  species,
  GO_type = "biological_process",
  GO_linkage_type = c("experimental", "phylogenetic", "computational", "author",
    "curator"),
  ...
)
}
\arguments{
\item{species}{species name matching ensembl biomaRt naming, such as hsapiens, mmusculus}

\item{GO_type}{GO term type, choose among 'biological_process', 'molecular_function', 'cellular_component', default 'biological_process'}

\item{GO_linkage_type}{GO annotation evidence codes set. Choose among 'experimental', 'phylogenetic', 'computational', 'author', 'curator', 'electronic', #' defaut remove 'electronic'}

\item{...}{additional args for useEnsembl}
}
\value{
a table with ensembl to GO terms mapping including requested linkage type
}
\description{
get requested ensembl ID to GO mapping table
}
\examples{
\donttest{
library(scGOclust)
library(httr)
httr::set_config(httr::config(ssl_verifypeer = FALSE))
ensemblToGo("mmusculus", GO_type = "biological_process", GO_linkage_type = "experimental")
}
}
