% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scDHA.R
\name{scDHA.w}
\alias{scDHA.w}
\title{scDHA.w}
\usage{
scDHA.w(data = data, sparse = FALSE, ncores = 10L, seed = NULL)
}
\arguments{
\item{data}{Gene expression matrix, with rows represent samples and columns represent genes.}

\item{sparse}{Boolen variable indicating whether data is a sparse matrix. The input must be a non negative sparse matrix.}

\item{ncores}{Number of processor cores to use.}

\item{seed}{Seed for reproducibility.}
}
\value{
A plot with normalized weights of all genes.
}
\description{
This function will plot a graph with normalized weights of all genes so user can select the appropriate number of genes to keep.
}
\examples{
\donttest{
library(scDHA)
#Load example data (Goolam dataset)
data('Goolam'); data <- t(Goolam$data); label <- as.character(Goolam$label)
#Log transform the data 
data <- log2(data + 1)
if(torch::torch_is_installed()) #scDHA need libtorch installed
{
  #Generate weight variances for each genes
  weight_variance <- scDHA.w(data, ncores = 2, seed = 1)
  #Plot weight variances for top 5,000 genes
  #plot(weight_variance, xlab = "Genes", ylab = "Normalized Weight Variance", xlim=c(1, 5000))
  #Plot the change of weight variances for top 5,000 genes
  #weight_variance_change <- weight_variance[-length(weight_variance)] - weight_variance[-1] 
  #plot(weight_variance_change, xlab = "Genes", ylab = "Weight Variance Change", xlim=c(1, 5000))
}
}
}
