% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session_validate.R
\name{session_validate}
\alias{session_validate}
\title{Validate sbtools session state}
\usage{
session_validate(session = current_session())
}
\arguments{
\item{session}{sbtools session object (from \code{\link{authenticate_sb}})}
}
\value{
\code{TRUE/FALSE} indicating if session is valid and can be used. 
  Returns TRUE if session is NULL as well.
}
\description{
A session is considered valid if it is NULL or a true, non-expired SB session
}
\details{
This validates the underyling RCurl session. The session object
becomes invalid if the R session has been saved to disk or persisted through
an R restart. This verifies that the session object is either valid, or is a
NULL object, which means no session state is being persisted. Note, this does
not verify the credentials are valid or that you have permission to access
the SB item, so it does not guarantee a successful request.
}
\examples{
\dontrun{
session = authenticate_sb('user@usgs.gov')

#return true as underlying RCurl session is valid
session_validate(session)
}

}

