% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_ps2.r
\name{sbpiper_ps2}
\alias{sbpiper_ps2}
\title{Main R function for SBpipe pipeline: parameter_scan2().}
\usage{
sbpiper_ps2(model, scanned_par1, scanned_par2, inputdir, outputdir, run)
}
\arguments{
\item{model}{the model name}

\item{scanned_par1}{the 1st scanned parameter}

\item{scanned_par2}{the 2nd scanned parameter}

\item{inputdir}{the input directory}

\item{outputdir}{the output directory}

\item{run}{the simulation run}
}
\description{
Main R function for SBpipe pipeline: parameter_scan2().
}
\examples{
\donttest{
data(insulin_receptor_ps2_tp2)
dir.create(file.path("ps2_datasets"))
write.table(insulin_receptor_ps2_tp2, 
            file=file.path("ps2_datasets", 
                           "insulin_receptor_InsulinPercent__IRbetaPercent__rep_1__tp_2.csv"), 
            row.names=FALSE)
sbpiper_ps2(model="insulin_receptor_InsulinPercent__IRbetaPercent", 
           scanned_par1="InsulinPercent", 
           scanned_par2="IRbetaPercent", 
           inputdir="ps2_datasets", 
           outputdir="ps2_plots", 
           run=1)
}
}
