% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_plots.r
\name{scatterplot_ple}
\alias{scatterplot_ple}
\title{Plot a profile likelihood estimation (PLE) scatter plot}
\usage{
scatterplot_ple(df, g = ggplot(), colNameX = "x", colNameY = "y",
  conf_level_66 = 0, conf_level_95 = 0, conf_level_99 = 0,
  dot_size = 0.1)
}
\arguments{
\item{df}{a data frame}

\item{g}{the current ggplot to overlap}

\item{colNameX}{the name of the column for the X axis}

\item{colNameY}{the name of the column for the Y axis}

\item{conf_level_66}{the 66\% confidence level to plot}

\item{conf_level_95}{the 95\% confidence level to plot}

\item{conf_level_99}{the 99\% confidence level to plot}

\item{dot_size}{the size of the dots in the scatterplot}
}
\value{
the plot
}
\description{
Plot a profile likelihood estimation (PLE) scatter plot
}
\examples{
a <- rnorm(10000)
b <- a^2+10
df<-data.frame(a, b)
scatterplot_ple(df, colNameX="a", colNameY="b", conf_level_66=0)
scatterplot_ple(df, colNameX="a", colNameY="b", 
                conf_level_66=13, conf_level_95=16.5, conf_level_99=20)
}
